// Template Source: BaseEntityCollectionRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.ReportRoot;
import com.microsoft.graph.models.extensions.PrintUsageByUser;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.requests.extensions.IPrintUsageByUserCollectionPage;
import com.microsoft.graph.requests.extensions.PrintUsageByUserCollectionResponse;
import com.microsoft.graph.requests.extensions.IPrintUsageByUserCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintUsageByUserCollectionRequest;
import com.microsoft.graph.requests.extensions.PrintUsageByUserCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Usage By User Collection Request.
 */
public class PrintUsageByUserCollectionRequest extends BaseCollectionRequest<PrintUsageByUserCollectionResponse, IPrintUsageByUserCollectionPage> implements IPrintUsageByUserCollectionRequest {

    /**
     * The request builder for this collection of PrintUsageByUser
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintUsageByUserCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintUsageByUserCollectionResponse.class, IPrintUsageByUserCollectionPage.class);
    }

    public void get(final ICallback<? super IPrintUsageByUserCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IPrintUsageByUserCollectionPage get() throws ClientException {
        final PrintUsageByUserCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final PrintUsageByUser newPrintUsageByUser, final ICallback<? super PrintUsageByUser> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new PrintUsageByUserRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .post(newPrintUsageByUser, callback);
    }

    public PrintUsageByUser post(final PrintUsageByUser newPrintUsageByUser) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new PrintUsageByUserRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .post(newPrintUsageByUser);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IPrintUsageByUserCollectionRequest expand(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (PrintUsageByUserCollectionRequest)this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    public IPrintUsageByUserCollectionRequest filter(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$filter", value));
        return (PrintUsageByUserCollectionRequest)this;
    }

    /**
     * Sets the order by clause for the request
     *
     * @param value the order by clause
     * @return the updated request
     */
    public IPrintUsageByUserCollectionRequest orderBy(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$orderby", value));
        return (PrintUsageByUserCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IPrintUsageByUserCollectionRequest select(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$select", value));
        return (PrintUsageByUserCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IPrintUsageByUserCollectionRequest top(final int value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$top", value + ""));
        return (PrintUsageByUserCollectionRequest)this;
    }

    /**
     * Sets the skip value for the request
     *
     * @param value of the number of items to skip
     * @return the updated request
     */
    public IPrintUsageByUserCollectionRequest skip(final int value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$skip", value + ""));
        return (PrintUsageByUserCollectionRequest)this;
    }


    /**
     * Add Skip token for pagination
     * @param skipToken - Token for pagination
     * @return the updated request
     */
    public IPrintUsageByUserCollectionRequest skipToken(final String skipToken) {
    	addQueryOption(new QueryOption("$skiptoken", skipToken));
        return (IPrintUsageByUserCollectionRequest)this;
    }
    public IPrintUsageByUserCollectionPage buildFromResponse(final PrintUsageByUserCollectionResponse response) {
        final IPrintUsageByUserCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new PrintUsageByUserCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final PrintUsageByUserCollectionPage page = new PrintUsageByUserCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
