// Template Source: BaseEntityReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.PrintTaskTrigger;
import com.microsoft.graph.requests.extensions.IPrintTaskDefinitionWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.PrintTaskDefinitionWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.core.IBaseClient;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Task Trigger Reference Request.
 */
public class PrintTaskTriggerReferenceRequest extends BaseRequest implements IPrintTaskTriggerReferenceRequest {

    /**
     * The request for the PrintTaskTrigger
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintTaskTriggerReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrintTaskTrigger.class);
    }

    public void delete(final ICallback<? super PrintTaskTrigger> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public PrintTaskTrigger delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IPrintTaskTriggerReferenceRequest select(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
        return (PrintTaskTriggerReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IPrintTaskTriggerReferenceRequest expand(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (PrintTaskTriggerReferenceRequest)this;
    }
    /**
     * Puts the PrintTaskTrigger
     *
     * @param srcPrintTaskTrigger the PrintTaskTrigger reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(PrintTaskTrigger srcPrintTaskTrigger, final ICallback<? super PrintTaskTrigger> callback) {
        send(HttpMethod.PUT, callback, srcPrintTaskTrigger);
    }

    /**
     * Puts the PrintTaskTrigger
     *
     * @param srcPrintTaskTrigger the PrintTaskTrigger reference to PUT
     * @return the PrintTaskTrigger
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public PrintTaskTrigger put(PrintTaskTrigger srcPrintTaskTrigger) throws ClientException {
        return send(HttpMethod.PUT, srcPrintTaskTrigger);
    }
}
