// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IPrintDocumentCreateUploadSessionRequest;
import com.microsoft.graph.requests.extensions.PrintDocumentCreateUploadSessionRequest;
import com.microsoft.graph.models.extensions.PrintDocumentUploadProperties;
import com.microsoft.graph.models.extensions.UploadSession;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Document Create Upload Session Request Builder.
 */
public class PrintDocumentCreateUploadSessionRequestBuilder extends BaseActionRequestBuilder implements IPrintDocumentCreateUploadSessionRequestBuilder {

    /**
     * The request builder for this PrintDocumentCreateUploadSession
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param properties the properties
     */
    public PrintDocumentCreateUploadSessionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final PrintDocumentUploadProperties properties) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("properties", properties);
    }

    /**
     * Creates the IPrintDocumentCreateUploadSessionRequest
     *
     * @param requestOptions the options for the request
     * @return the IPrintDocumentCreateUploadSessionRequest instance
     */
    public IPrintDocumentCreateUploadSessionRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IPrintDocumentCreateUploadSessionRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IPrintDocumentCreateUploadSessionRequest instance
     */
    public IPrintDocumentCreateUploadSessionRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        PrintDocumentCreateUploadSessionRequest request = new PrintDocumentCreateUploadSessionRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("properties")) {
            request.body.properties = getParameter("properties");
        }

        return request;
    }
}
