// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.MicrosoftAuthenticatorAuthenticationMethodConfiguration;
import com.microsoft.graph.models.extensions.MicrosoftAuthenticatorAuthenticationMethodTarget;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IMicrosoftAuthenticatorAuthenticationMethodTargetRequestBuilder;
import com.microsoft.graph.requests.extensions.IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.core.IBaseClient;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Microsoft Authenticator Authentication Method Target Collection Request Builder.
 */
public class MicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequestBuilder extends BaseRequestBuilder implements IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequestBuilder {

    /**
     * The request builder for this collection of MicrosoftAuthenticatorAuthenticationMethodConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IUserRequest instance
     */
    public IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IUserRequest instance
     */
    public IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new MicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IMicrosoftAuthenticatorAuthenticationMethodTargetRequestBuilder byId(final String id) {
        return new MicrosoftAuthenticatorAuthenticationMethodTargetRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }


}
