// Template Source: BaseEntityCollectionRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.MicrosoftAuthenticatorAuthenticationMethodConfiguration;
import com.microsoft.graph.models.extensions.MicrosoftAuthenticatorAuthenticationMethodTarget;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.requests.extensions.IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionPage;
import com.microsoft.graph.requests.extensions.MicrosoftAuthenticatorAuthenticationMethodTargetCollectionResponse;
import com.microsoft.graph.requests.extensions.IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest;
import com.microsoft.graph.requests.extensions.MicrosoftAuthenticatorAuthenticationMethodTargetCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Microsoft Authenticator Authentication Method Target Collection Request.
 */
public class MicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest extends BaseCollectionRequest<MicrosoftAuthenticatorAuthenticationMethodTargetCollectionResponse, IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionPage> implements IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest {

    /**
     * The request builder for this collection of MicrosoftAuthenticatorAuthenticationMethodTarget
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MicrosoftAuthenticatorAuthenticationMethodTargetCollectionResponse.class, IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionPage.class);
    }

    public void get(final ICallback<? super IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionPage get() throws ClientException {
        final MicrosoftAuthenticatorAuthenticationMethodTargetCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final MicrosoftAuthenticatorAuthenticationMethodTarget newMicrosoftAuthenticatorAuthenticationMethodTarget, final ICallback<? super MicrosoftAuthenticatorAuthenticationMethodTarget> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new MicrosoftAuthenticatorAuthenticationMethodTargetRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .post(newMicrosoftAuthenticatorAuthenticationMethodTarget, callback);
    }

    public MicrosoftAuthenticatorAuthenticationMethodTarget post(final MicrosoftAuthenticatorAuthenticationMethodTarget newMicrosoftAuthenticatorAuthenticationMethodTarget) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new MicrosoftAuthenticatorAuthenticationMethodTargetRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .post(newMicrosoftAuthenticatorAuthenticationMethodTarget);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest expand(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (MicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest)this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    public IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest filter(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$filter", value));
        return (MicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest)this;
    }

    /**
     * Sets the order by clause for the request
     *
     * @param value the order by clause
     * @return the updated request
     */
    public IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest orderBy(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$orderby", value));
        return (MicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest select(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$select", value));
        return (MicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest top(final int value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$top", value + ""));
        return (MicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest)this;
    }

    /**
     * Sets the skip value for the request
     *
     * @param value of the number of items to skip
     * @return the updated request
     */
    public IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest skip(final int value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$skip", value + ""));
        return (MicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest)this;
    }


    /**
     * Add Skip token for pagination
     * @param skipToken - Token for pagination
     * @return the updated request
     */
    public IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest skipToken(final String skipToken) {
    	addQueryOption(new QueryOption("$skiptoken", skipToken));
        return (IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequest)this;
    }
    public IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionPage buildFromResponse(final MicrosoftAuthenticatorAuthenticationMethodTargetCollectionResponse response) {
        final IMicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new MicrosoftAuthenticatorAuthenticationMethodTargetCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final MicrosoftAuthenticatorAuthenticationMethodTargetCollectionPage page = new MicrosoftAuthenticatorAuthenticationMethodTargetCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
