// Template Source: IBaseMethodRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookChartSeries;
import com.microsoft.graph.requests.extensions.IWorkbookChartSeriesItemAtRequest;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Chart Series Item At Request.
 */
public interface IWorkbookChartSeriesItemAtRequest extends IHttpRequest {

    /**
     * Patches the WorkbookChartSeriesItemAt
     *
     * @param srcWorkbookChartSeries the WorkbookChartSeries with which to PATCH
     * @param callback the callback to be called after success or failure
     */
    void patch(WorkbookChartSeries srcWorkbookChartSeries, final ICallback<? super WorkbookChartSeries> callback);

    /**
     * Patches the WorkbookChartSeriesItemAt
     *
     * @param srcWorkbookChartSeries the WorkbookChartSeries with which to PATCH
     * @return the WorkbookChartSeries
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    WorkbookChartSeries patch(WorkbookChartSeries srcWorkbookChartSeries) throws ClientException;

    /**
     * Puts the WorkbookChartSeriesItemAt
     *
     * @param srcWorkbookChartSeries the WorkbookChartSeries to PUT
     * @param callback the callback to be called after success or failure
     */
    void put(WorkbookChartSeries srcWorkbookChartSeries, final ICallback<? super WorkbookChartSeries> callback);

    /**
     * Puts the WorkbookChartSeriesItemAt
     *
     * @param srcWorkbookChartSeries the WorkbookChartSeries to PUT
     * @return the WorkbookChartSeries
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
     WorkbookChartSeries put(WorkbookChartSeries srcWorkbookChartSeries) throws ClientException;
    /**
     * Gets the WorkbookChartSeries
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super WorkbookChartSeries> callback);

    /**
     * Gets the WorkbookChartSeries
     *
     * @return the WorkbookChartSeries
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    WorkbookChartSeries get() throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookChartSeriesItemAtRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookChartSeriesItemAtRequest expand(final String value);

}
