// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WindowsMobileMSI;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Windows Mobile MSIRequest.
 */
public interface IWindowsMobileMSIRequest extends IHttpRequest {

    /**
     * Gets the WindowsMobileMSI from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super WindowsMobileMSI> callback);

    /**
     * Gets the WindowsMobileMSI from the service
     *
     * @return the WindowsMobileMSI from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsMobileMSI get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super WindowsMobileMSI> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WindowsMobileMSI with a source
     *
     * @param sourceWindowsMobileMSI the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WindowsMobileMSI sourceWindowsMobileMSI, final ICallback<? super WindowsMobileMSI> callback);

    /**
     * Patches this WindowsMobileMSI with a source
     *
     * @param sourceWindowsMobileMSI the source object with updates
     * @return the updated WindowsMobileMSI
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsMobileMSI patch(final WindowsMobileMSI sourceWindowsMobileMSI) throws ClientException;

    /**
     * Posts a WindowsMobileMSI with a new object
     *
     * @param newWindowsMobileMSI the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WindowsMobileMSI newWindowsMobileMSI, final ICallback<? super WindowsMobileMSI> callback);

    /**
     * Posts a WindowsMobileMSI with a new object
     *
     * @param newWindowsMobileMSI the new object to create
     * @return the created WindowsMobileMSI
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsMobileMSI post(final WindowsMobileMSI newWindowsMobileMSI) throws ClientException;

    /**
     * Posts a WindowsMobileMSI with a new object
     *
     * @param newWindowsMobileMSI the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final WindowsMobileMSI newWindowsMobileMSI, final ICallback<? super WindowsMobileMSI> callback);

    /**
     * Posts a WindowsMobileMSI with a new object
     *
     * @param newWindowsMobileMSI the object to create/update
     * @return the created WindowsMobileMSI
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WindowsMobileMSI put(final WindowsMobileMSI newWindowsMobileMSI) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWindowsMobileMSIRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWindowsMobileMSIRequest expand(final String value);

}

