// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.TeamworkBot;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Teamwork Bot Request.
 */
public interface ITeamworkBotRequest extends IHttpRequest {

    /**
     * Gets the TeamworkBot from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super TeamworkBot> callback);

    /**
     * Gets the TeamworkBot from the service
     *
     * @return the TeamworkBot from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TeamworkBot get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super TeamworkBot> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this TeamworkBot with a source
     *
     * @param sourceTeamworkBot the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final TeamworkBot sourceTeamworkBot, final ICallback<? super TeamworkBot> callback);

    /**
     * Patches this TeamworkBot with a source
     *
     * @param sourceTeamworkBot the source object with updates
     * @return the updated TeamworkBot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TeamworkBot patch(final TeamworkBot sourceTeamworkBot) throws ClientException;

    /**
     * Posts a TeamworkBot with a new object
     *
     * @param newTeamworkBot the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final TeamworkBot newTeamworkBot, final ICallback<? super TeamworkBot> callback);

    /**
     * Posts a TeamworkBot with a new object
     *
     * @param newTeamworkBot the new object to create
     * @return the created TeamworkBot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TeamworkBot post(final TeamworkBot newTeamworkBot) throws ClientException;

    /**
     * Posts a TeamworkBot with a new object
     *
     * @param newTeamworkBot the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final TeamworkBot newTeamworkBot, final ICallback<? super TeamworkBot> callback);

    /**
     * Posts a TeamworkBot with a new object
     *
     * @param newTeamworkBot the object to create/update
     * @return the created TeamworkBot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TeamworkBot put(final TeamworkBot newTeamworkBot) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ITeamworkBotRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ITeamworkBotRequest expand(final String value);

}

