// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.SecureScore;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Secure Score Request.
 */
public interface ISecureScoreRequest extends IHttpRequest {

    /**
     * Gets the SecureScore from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super SecureScore> callback);

    /**
     * Gets the SecureScore from the service
     *
     * @return the SecureScore from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SecureScore get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super SecureScore> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this SecureScore with a source
     *
     * @param sourceSecureScore the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final SecureScore sourceSecureScore, final ICallback<? super SecureScore> callback);

    /**
     * Patches this SecureScore with a source
     *
     * @param sourceSecureScore the source object with updates
     * @return the updated SecureScore
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SecureScore patch(final SecureScore sourceSecureScore) throws ClientException;

    /**
     * Posts a SecureScore with a new object
     *
     * @param newSecureScore the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final SecureScore newSecureScore, final ICallback<? super SecureScore> callback);

    /**
     * Posts a SecureScore with a new object
     *
     * @param newSecureScore the new object to create
     * @return the created SecureScore
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SecureScore post(final SecureScore newSecureScore) throws ClientException;

    /**
     * Posts a SecureScore with a new object
     *
     * @param newSecureScore the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final SecureScore newSecureScore, final ICallback<? super SecureScore> callback);

    /**
     * Posts a SecureScore with a new object
     *
     * @param newSecureScore the object to create/update
     * @return the created SecureScore
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    SecureScore put(final SecureScore newSecureScore) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ISecureScoreRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ISecureScoreRequest expand(final String value);

}

