// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ProfilePhoto;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Profile Photo Request.
 */
public interface IProfilePhotoRequest extends IHttpRequest {

    /**
     * Gets the ProfilePhoto from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super ProfilePhoto> callback);

    /**
     * Gets the ProfilePhoto from the service
     *
     * @return the ProfilePhoto from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ProfilePhoto get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super ProfilePhoto> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ProfilePhoto with a source
     *
     * @param sourceProfilePhoto the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ProfilePhoto sourceProfilePhoto, final ICallback<? super ProfilePhoto> callback);

    /**
     * Patches this ProfilePhoto with a source
     *
     * @param sourceProfilePhoto the source object with updates
     * @return the updated ProfilePhoto
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ProfilePhoto patch(final ProfilePhoto sourceProfilePhoto) throws ClientException;

    /**
     * Posts a ProfilePhoto with a new object
     *
     * @param newProfilePhoto the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ProfilePhoto newProfilePhoto, final ICallback<? super ProfilePhoto> callback);

    /**
     * Posts a ProfilePhoto with a new object
     *
     * @param newProfilePhoto the new object to create
     * @return the created ProfilePhoto
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ProfilePhoto post(final ProfilePhoto newProfilePhoto) throws ClientException;

    /**
     * Posts a ProfilePhoto with a new object
     *
     * @param newProfilePhoto the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ProfilePhoto newProfilePhoto, final ICallback<? super ProfilePhoto> callback);

    /**
     * Posts a ProfilePhoto with a new object
     *
     * @param newProfilePhoto the object to create/update
     * @return the created ProfilePhoto
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ProfilePhoto put(final ProfilePhoto newProfilePhoto) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IProfilePhotoRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IProfilePhotoRequest expand(final String value);

}

