// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.PrinterShare;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Printer Share Request.
 */
public interface IPrinterShareRequest extends IHttpRequest {

    /**
     * Gets the PrinterShare from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super PrinterShare> callback);

    /**
     * Gets the PrinterShare from the service
     *
     * @return the PrinterShare from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrinterShare get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super PrinterShare> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this PrinterShare with a source
     *
     * @param sourcePrinterShare the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final PrinterShare sourcePrinterShare, final ICallback<? super PrinterShare> callback);

    /**
     * Patches this PrinterShare with a source
     *
     * @param sourcePrinterShare the source object with updates
     * @return the updated PrinterShare
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrinterShare patch(final PrinterShare sourcePrinterShare) throws ClientException;

    /**
     * Posts a PrinterShare with a new object
     *
     * @param newPrinterShare the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final PrinterShare newPrinterShare, final ICallback<? super PrinterShare> callback);

    /**
     * Posts a PrinterShare with a new object
     *
     * @param newPrinterShare the new object to create
     * @return the created PrinterShare
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrinterShare post(final PrinterShare newPrinterShare) throws ClientException;

    /**
     * Posts a PrinterShare with a new object
     *
     * @param newPrinterShare the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final PrinterShare newPrinterShare, final ICallback<? super PrinterShare> callback);

    /**
     * Posts a PrinterShare with a new object
     *
     * @param newPrinterShare the object to create/update
     * @return the created PrinterShare
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrinterShare put(final PrinterShare newPrinterShare) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IPrinterShareRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IPrinterShareRequest expand(final String value);

}

