// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.PrinterCreateOperation;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Printer Create Operation Request.
 */
public interface IPrinterCreateOperationRequest extends IHttpRequest {

    /**
     * Gets the PrinterCreateOperation from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super PrinterCreateOperation> callback);

    /**
     * Gets the PrinterCreateOperation from the service
     *
     * @return the PrinterCreateOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrinterCreateOperation get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super PrinterCreateOperation> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this PrinterCreateOperation with a source
     *
     * @param sourcePrinterCreateOperation the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final PrinterCreateOperation sourcePrinterCreateOperation, final ICallback<? super PrinterCreateOperation> callback);

    /**
     * Patches this PrinterCreateOperation with a source
     *
     * @param sourcePrinterCreateOperation the source object with updates
     * @return the updated PrinterCreateOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrinterCreateOperation patch(final PrinterCreateOperation sourcePrinterCreateOperation) throws ClientException;

    /**
     * Posts a PrinterCreateOperation with a new object
     *
     * @param newPrinterCreateOperation the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final PrinterCreateOperation newPrinterCreateOperation, final ICallback<? super PrinterCreateOperation> callback);

    /**
     * Posts a PrinterCreateOperation with a new object
     *
     * @param newPrinterCreateOperation the new object to create
     * @return the created PrinterCreateOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrinterCreateOperation post(final PrinterCreateOperation newPrinterCreateOperation) throws ClientException;

    /**
     * Posts a PrinterCreateOperation with a new object
     *
     * @param newPrinterCreateOperation the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final PrinterCreateOperation newPrinterCreateOperation, final ICallback<? super PrinterCreateOperation> callback);

    /**
     * Posts a PrinterCreateOperation with a new object
     *
     * @param newPrinterCreateOperation the object to create/update
     * @return the created PrinterCreateOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrinterCreateOperation put(final PrinterCreateOperation newPrinterCreateOperation) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IPrinterCreateOperationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IPrinterCreateOperationRequest expand(final String value);

}

