// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.PrintTaskTrigger;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Print Task Trigger Request.
 */
public interface IPrintTaskTriggerRequest extends IHttpRequest {

    /**
     * Gets the PrintTaskTrigger from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super PrintTaskTrigger> callback);

    /**
     * Gets the PrintTaskTrigger from the service
     *
     * @return the PrintTaskTrigger from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrintTaskTrigger get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super PrintTaskTrigger> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this PrintTaskTrigger with a source
     *
     * @param sourcePrintTaskTrigger the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final PrintTaskTrigger sourcePrintTaskTrigger, final ICallback<? super PrintTaskTrigger> callback);

    /**
     * Patches this PrintTaskTrigger with a source
     *
     * @param sourcePrintTaskTrigger the source object with updates
     * @return the updated PrintTaskTrigger
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrintTaskTrigger patch(final PrintTaskTrigger sourcePrintTaskTrigger) throws ClientException;

    /**
     * Posts a PrintTaskTrigger with a new object
     *
     * @param newPrintTaskTrigger the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final PrintTaskTrigger newPrintTaskTrigger, final ICallback<? super PrintTaskTrigger> callback);

    /**
     * Posts a PrintTaskTrigger with a new object
     *
     * @param newPrintTaskTrigger the new object to create
     * @return the created PrintTaskTrigger
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrintTaskTrigger post(final PrintTaskTrigger newPrintTaskTrigger) throws ClientException;

    /**
     * Posts a PrintTaskTrigger with a new object
     *
     * @param newPrintTaskTrigger the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final PrintTaskTrigger newPrintTaskTrigger, final ICallback<? super PrintTaskTrigger> callback);

    /**
     * Posts a PrintTaskTrigger with a new object
     *
     * @param newPrintTaskTrigger the object to create/update
     * @return the created PrintTaskTrigger
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PrintTaskTrigger put(final PrintTaskTrigger newPrintTaskTrigger) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IPrintTaskTriggerRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IPrintTaskTriggerRequest expand(final String value);

}

