// Template Source: IBaseEntityWithReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.PrintTaskDefinition;
import com.microsoft.graph.requests.extensions.IPrintTaskCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintTaskRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.PrintTaskDefinition;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;


// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Print Task Definition With Reference Request.
 */
public interface IPrintTaskDefinitionWithReferenceRequest extends IHttpRequest {

    void post(final PrintTaskDefinition newPrintTaskDefinition, final IJsonBackedObject payload, final ICallback<? super PrintTaskDefinition> callback);

    PrintTaskDefinition post(final PrintTaskDefinition newPrintTaskDefinition, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<? super PrintTaskDefinition> callback);

    PrintTaskDefinition get() throws ClientException;

	void delete(final ICallback<? super PrintTaskDefinition> callback);

	void delete() throws ClientException;

	void patch(final PrintTaskDefinition sourcePrintTaskDefinition, final ICallback<? super PrintTaskDefinition> callback);

	PrintTaskDefinition patch(final PrintTaskDefinition sourcePrintTaskDefinition) throws ClientException;

    IPrintTaskDefinitionWithReferenceRequest select(final String value);

    IPrintTaskDefinitionWithReferenceRequest expand(final String value);

}
