// Template Source: IBaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Print;
import com.microsoft.graph.requests.extensions.IPrintConnectorCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintConnectorRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintOperationRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrinterCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrinterRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintServiceCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintServiceRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrinterShareCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrinterShareRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintTaskDefinitionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintTaskDefinitionRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Print Request Builder.
 */
public interface IPrintRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IPrintRequest instance
     */
    IPrintRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions);

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IPrintRequest instance
     */
    IPrintRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions);


    IPrintConnectorCollectionRequestBuilder connectors();

    IPrintConnectorRequestBuilder connectors(final String id);

    IPrintOperationCollectionRequestBuilder operations();

    IPrintOperationRequestBuilder operations(final String id);

    IPrinterCollectionRequestBuilder printers();

    IPrinterRequestBuilder printers(final String id);

    IPrintServiceCollectionRequestBuilder services();

    IPrintServiceRequestBuilder services(final String id);

    IPrinterShareCollectionRequestBuilder shares();

    IPrinterShareRequestBuilder shares(final String id);

    IPrintTaskDefinitionCollectionRequestBuilder taskDefinitions();

    IPrintTaskDefinitionRequestBuilder taskDefinitions(final String id);

}