// Template Source: IBaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.PrintJob;
import com.microsoft.graph.models.extensions.PrintJobConfiguration;
import com.microsoft.graph.models.extensions.PrintJobStatus;
import com.microsoft.graph.requests.extensions.IPrintDocumentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintDocumentRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintTaskCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IPrintTaskRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Print Job Request Builder.
 */
public interface IPrintJobRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IPrintJobRequest instance
     */
    IPrintJobRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions);

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IPrintJobRequest instance
     */
    IPrintJobRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions);


    IPrintDocumentCollectionRequestBuilder documents();

    IPrintDocumentRequestBuilder documents(final String id);

    IPrintTaskCollectionRequestBuilder tasks();

    IPrintTaskRequestBuilder tasks(final String id);
    IPrintJobCancelRequestBuilder cancel();
    IPrintJobAbortRequestBuilder abort(final String reason);
    IPrintJobRedirectRequestBuilder redirect(final String destinationPrinterId, final PrintJobConfiguration configuration);
    IPrintJobStartRequestBuilder start();

}