// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.AgreementFileProperties;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Agreement File Properties Request.
 */
public interface IAgreementFilePropertiesRequest extends IHttpRequest {

    /**
     * Gets the AgreementFileProperties from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super AgreementFileProperties> callback);

    /**
     * Gets the AgreementFileProperties from the service
     *
     * @return the AgreementFileProperties from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementFileProperties get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super AgreementFileProperties> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this AgreementFileProperties with a source
     *
     * @param sourceAgreementFileProperties the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final AgreementFileProperties sourceAgreementFileProperties, final ICallback<? super AgreementFileProperties> callback);

    /**
     * Patches this AgreementFileProperties with a source
     *
     * @param sourceAgreementFileProperties the source object with updates
     * @return the updated AgreementFileProperties
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementFileProperties patch(final AgreementFileProperties sourceAgreementFileProperties) throws ClientException;

    /**
     * Posts a AgreementFileProperties with a new object
     *
     * @param newAgreementFileProperties the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final AgreementFileProperties newAgreementFileProperties, final ICallback<? super AgreementFileProperties> callback);

    /**
     * Posts a AgreementFileProperties with a new object
     *
     * @param newAgreementFileProperties the new object to create
     * @return the created AgreementFileProperties
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementFileProperties post(final AgreementFileProperties newAgreementFileProperties) throws ClientException;

    /**
     * Posts a AgreementFileProperties with a new object
     *
     * @param newAgreementFileProperties the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final AgreementFileProperties newAgreementFileProperties, final ICallback<? super AgreementFileProperties> callback);

    /**
     * Posts a AgreementFileProperties with a new object
     *
     * @param newAgreementFileProperties the object to create/update
     * @return the created AgreementFileProperties
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AgreementFileProperties put(final AgreementFileProperties newAgreementFileProperties) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IAgreementFilePropertiesRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IAgreementFilePropertiesRequest expand(final String value);

}

