// Template Source: IBaseEntityWithReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.AgreementAcceptance;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.AgreementAcceptance;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;


// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Agreement Acceptance With Reference Request.
 */
public interface IAgreementAcceptanceWithReferenceRequest extends IHttpRequest {

    void post(final AgreementAcceptance newAgreementAcceptance, final IJsonBackedObject payload, final ICallback<? super AgreementAcceptance> callback);

    AgreementAcceptance post(final AgreementAcceptance newAgreementAcceptance, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<? super AgreementAcceptance> callback);

    AgreementAcceptance get() throws ClientException;

	void delete(final ICallback<? super AgreementAcceptance> callback);

	void delete() throws ClientException;

	void patch(final AgreementAcceptance sourceAgreementAcceptance, final ICallback<? super AgreementAcceptance> callback);

	AgreementAcceptance patch(final AgreementAcceptance sourceAgreementAcceptance) throws ClientException;

    IAgreementAcceptanceWithReferenceRequest select(final String value);

    IAgreementAcceptanceWithReferenceRequest expand(final String value);

}
