// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.ContactFolder;
import com.microsoft.graph.requests.extensions.IContactFolderCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IContactFolderRequestBuilder;
import com.microsoft.graph.requests.extensions.ContactFolderCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ContactFolderRequestBuilder;
import com.microsoft.graph.requests.extensions.IContactCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IContactRequestBuilder;
import com.microsoft.graph.requests.extensions.ContactCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ContactRequestBuilder;
import com.microsoft.graph.requests.extensions.IMultiValueLegacyExtendedPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IMultiValueLegacyExtendedPropertyRequestBuilder;
import com.microsoft.graph.requests.extensions.MultiValueLegacyExtendedPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MultiValueLegacyExtendedPropertyRequestBuilder;
import com.microsoft.graph.requests.extensions.ISingleValueLegacyExtendedPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ISingleValueLegacyExtendedPropertyRequestBuilder;
import com.microsoft.graph.requests.extensions.SingleValueLegacyExtendedPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SingleValueLegacyExtendedPropertyRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Contact Folder Request.
 */
public class ContactFolderRequest extends BaseRequest implements IContactFolderRequest {
	
    /**
     * The request for the ContactFolder
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ContactFolderRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ContactFolder.class);
    }

    /**
     * Gets the ContactFolder from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super ContactFolder> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the ContactFolder from the service
     *
     * @return the ContactFolder from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ContactFolder get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super ContactFolder> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ContactFolder with a source
     *
     * @param sourceContactFolder the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final ContactFolder sourceContactFolder, final ICallback<? super ContactFolder> callback) {
        send(HttpMethod.PATCH, callback, sourceContactFolder);
    }

    /**
     * Patches this ContactFolder with a source
     *
     * @param sourceContactFolder the source object with updates
     * @return the updated ContactFolder
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ContactFolder patch(final ContactFolder sourceContactFolder) throws ClientException {
        return send(HttpMethod.PATCH, sourceContactFolder);
    }

    /**
     * Creates a ContactFolder with a new object
     *
     * @param newContactFolder the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final ContactFolder newContactFolder, final ICallback<? super ContactFolder> callback) {
        send(HttpMethod.POST, callback, newContactFolder);
    }

    /**
     * Creates a ContactFolder with a new object
     *
     * @param newContactFolder the new object to create
     * @return the created ContactFolder
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ContactFolder post(final ContactFolder newContactFolder) throws ClientException {
        return send(HttpMethod.POST, newContactFolder);
    }

    /**
     * Creates a ContactFolder with a new object
     *
     * @param newContactFolder the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final ContactFolder newContactFolder, final ICallback<? super ContactFolder> callback) {
        send(HttpMethod.PUT, callback, newContactFolder);
    }

    /**
     * Creates a ContactFolder with a new object
     *
     * @param newContactFolder the object to create/update
     * @return the created ContactFolder
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ContactFolder put(final ContactFolder newContactFolder) throws ClientException {
        return send(HttpMethod.PUT, newContactFolder);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IContactFolderRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (ContactFolderRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IContactFolderRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (ContactFolderRequest)this;
     }

}

