// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Video.
 */
public class Video implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Audio Bits Per Sample.
     * Number of audio bits per sample.
     */
    @SerializedName(value = "audioBitsPerSample", alternate = {"AudioBitsPerSample"})
    @Expose
    public Integer audioBitsPerSample;

    /**
     * The Audio Channels.
     * Number of audio channels.
     */
    @SerializedName(value = "audioChannels", alternate = {"AudioChannels"})
    @Expose
    public Integer audioChannels;

    /**
     * The Audio Format.
     * Name of the audio format (AAC, MP3, etc.).
     */
    @SerializedName(value = "audioFormat", alternate = {"AudioFormat"})
    @Expose
    public String audioFormat;

    /**
     * The Audio Samples Per Second.
     * Number of audio samples per second.
     */
    @SerializedName(value = "audioSamplesPerSecond", alternate = {"AudioSamplesPerSecond"})
    @Expose
    public Integer audioSamplesPerSecond;

    /**
     * The Bitrate.
     * Bit rate of the video in bits per second.
     */
    @SerializedName(value = "bitrate", alternate = {"Bitrate"})
    @Expose
    public Integer bitrate;

    /**
     * The Duration.
     * Duration of the file in milliseconds.
     */
    @SerializedName(value = "duration", alternate = {"Duration"})
    @Expose
    public Long duration;

    /**
     * The Four CC.
     * 'Four character code' name of the video format.
     */
    @SerializedName(value = "fourCC", alternate = {"FourCC"})
    @Expose
    public String fourCC;

    /**
     * The Frame Rate.
     * Frame rate of the video.
     */
    @SerializedName(value = "frameRate", alternate = {"FrameRate"})
    @Expose
    public Double frameRate;

    /**
     * The Height.
     * Height of the video, in pixels.
     */
    @SerializedName(value = "height", alternate = {"Height"})
    @Expose
    public Integer height;

    /**
     * The Width.
     * Width of the video, in pixels.
     */
    @SerializedName(value = "width", alternate = {"Width"})
    @Expose
    public Integer width;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
