// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.PhysicalAddress;
import com.microsoft.graph.models.extensions.OutlookGeoCoordinates;
import com.microsoft.graph.models.generated.LocationType;
import com.microsoft.graph.models.generated.LocationUniqueIdType;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Location.
 */
public class Location implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Address.
     * The street address of the location.
     */
    @SerializedName(value = "address", alternate = {"Address"})
    @Expose
    public PhysicalAddress address;

    /**
     * The Coordinates.
     * The geographic coordinates and elevation of the location.
     */
    @SerializedName(value = "coordinates", alternate = {"Coordinates"})
    @Expose
    public OutlookGeoCoordinates coordinates;

    /**
     * The Display Name.
     * The name associated with the location.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
    public String displayName;

    /**
     * The Location Email Address.
     * Optional email address of the location.
     */
    @SerializedName(value = "locationEmailAddress", alternate = {"LocationEmailAddress"})
    @Expose
    public String locationEmailAddress;

    /**
     * The Location Type.
     * The type of location. Possible values are: default, conferenceRoom, homeAddress, businessAddress,geoCoordinates, streetAddress, hotel, restaurant, localBusiness, postalAddress. Read-only.
     */
    @SerializedName(value = "locationType", alternate = {"LocationType"})
    @Expose
    public LocationType locationType;

    /**
     * The Location Uri.
     * Optional URI representing the location.
     */
    @SerializedName(value = "locationUri", alternate = {"LocationUri"})
    @Expose
    public String locationUri;

    /**
     * The Unique Id.
     * For internal use only.
     */
    @SerializedName(value = "uniqueId", alternate = {"UniqueId"})
    @Expose
    public String uniqueId;

    /**
     * The Unique Id Type.
     * For internal use only.
     */
    @SerializedName(value = "uniqueIdType", alternate = {"UniqueIdType"})
    @Expose
    public LocationUniqueIdType uniqueIdType;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
