// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity Provider.
 */
public class IdentityProvider extends Entity implements IJsonBackedObject {


    /**
     * The Client Id.
     * The client ID for the application obtained when registering the application with the identity provider. This is a required field.
     */
    @SerializedName(value = "clientId", alternate = {"ClientId"})
    @Expose
    public String clientId;

    /**
     * The Client Secret.
     * The client secret for the application obtained when registering the application with the identity provider. This is write-only. A read operation will return '****'. This is a required field.
     */
    @SerializedName(value = "clientSecret", alternate = {"ClientSecret"})
    @Expose
    public String clientSecret;

    /**
     * The Name.
     * The display name of the identity provider.
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
    public String name;

    /**
     * The Type.
     * The identity provider type is a required field.For B2B scenario:GoogleFacebookFor B2C scenario:MicrosoftGoogleAmazonLinkedInFacebookGitHubTwitterWeiboQQWeChatOpenIDConnect
     */
    @SerializedName(value = "type", alternate = {"Type"})
    @Expose
    public String type;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
