/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Site;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISiteCollectionPage;
import com.microsoft.graph.requests.extensions.ISiteCollectionRequest;
import com.microsoft.graph.requests.extensions.SiteCollectionPage;
import com.microsoft.graph.requests.extensions.SiteCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SiteCollectionResponse;
import com.microsoft.graph.requests.extensions.SiteRequestBuilder;
import java.util.List;

public class SiteCollectionRequest
extends BaseCollectionRequest<SiteCollectionResponse, ISiteCollectionPage>
implements ISiteCollectionRequest {
    public SiteCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SiteCollectionResponse.class, ISiteCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISiteCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SiteCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISiteCollectionPage get() throws ClientException {
        SiteCollectionResponse response = (SiteCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Site newSite, ICallback<Site> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SiteRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSite, callback);
    }

    @Override
    public Site post(Site newSite) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SiteRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSite);
    }

    @Override
    public ISiteCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISiteCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISiteCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ISiteCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ISiteCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ISiteCollectionPage buildFromResponse(SiteCollectionResponse response) {
        SiteCollectionRequestBuilder builder = response.nextLink != null ? new SiteCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SiteCollectionPage page = new SiteCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

