/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.SecureScore;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISecureScoreCollectionPage;
import com.microsoft.graph.requests.extensions.ISecureScoreCollectionRequest;
import com.microsoft.graph.requests.extensions.SecureScoreCollectionPage;
import com.microsoft.graph.requests.extensions.SecureScoreCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SecureScoreCollectionResponse;
import com.microsoft.graph.requests.extensions.SecureScoreRequestBuilder;
import java.util.List;

public class SecureScoreCollectionRequest
extends BaseCollectionRequest<SecureScoreCollectionResponse, ISecureScoreCollectionPage>
implements ISecureScoreCollectionRequest {
    public SecureScoreCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SecureScoreCollectionResponse.class, ISecureScoreCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISecureScoreCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SecureScoreCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISecureScoreCollectionPage get() throws ClientException {
        SecureScoreCollectionResponse response = (SecureScoreCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SecureScore newSecureScore, ICallback<SecureScore> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SecureScoreRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSecureScore, callback);
    }

    @Override
    public SecureScore post(SecureScore newSecureScore) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SecureScoreRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSecureScore);
    }

    @Override
    public ISecureScoreCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISecureScoreCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISecureScoreCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ISecureScoreCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ISecureScoreCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ISecureScoreCollectionPage buildFromResponse(SecureScoreCollectionResponse response) {
        SecureScoreCollectionRequestBuilder builder = response.nextLink != null ? new SecureScoreCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SecureScoreCollectionPage page = new SecureScoreCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

