/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.OrgContact;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOrgContactCollectionPage;
import com.microsoft.graph.requests.extensions.IOrgContactCollectionRequest;
import com.microsoft.graph.requests.extensions.OrgContactCollectionPage;
import com.microsoft.graph.requests.extensions.OrgContactCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OrgContactCollectionResponse;
import com.microsoft.graph.requests.extensions.OrgContactRequestBuilder;
import java.util.List;

public class OrgContactCollectionRequest
extends BaseCollectionRequest<OrgContactCollectionResponse, IOrgContactCollectionPage>
implements IOrgContactCollectionRequest {
    public OrgContactCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OrgContactCollectionResponse.class, IOrgContactCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IOrgContactCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(OrgContactCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOrgContactCollectionPage get() throws ClientException {
        OrgContactCollectionResponse response = (OrgContactCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(OrgContact newOrgContact, ICallback<OrgContact> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new OrgContactRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOrgContact, callback);
    }

    @Override
    public OrgContact post(OrgContact newOrgContact) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OrgContactRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOrgContact);
    }

    @Override
    public IOrgContactCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IOrgContactCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOrgContactCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IOrgContactCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IOrgContactCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IOrgContactCollectionPage buildFromResponse(OrgContactCollectionResponse response) {
        OrgContactCollectionRequestBuilder builder = response.nextLink != null ? new OrgContactCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OrgContactCollectionPage page = new OrgContactCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

