/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.OpenShift;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOpenShiftRequest;
import java.util.List;

public class OpenShiftRequest
extends BaseRequest
implements IOpenShiftRequest {
    public OpenShiftRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OpenShift.class);
    }

    @Override
    public void get(ICallback<OpenShift> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public OpenShift get() throws ClientException {
        return (OpenShift)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<OpenShift> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(OpenShift sourceOpenShift, ICallback<OpenShift> callback) {
        this.send(HttpMethod.PATCH, callback, sourceOpenShift);
    }

    @Override
    public OpenShift patch(OpenShift sourceOpenShift) throws ClientException {
        return (OpenShift)this.send(HttpMethod.PATCH, sourceOpenShift);
    }

    @Override
    public void post(OpenShift newOpenShift, ICallback<OpenShift> callback) {
        this.send(HttpMethod.POST, callback, newOpenShift);
    }

    @Override
    public OpenShift post(OpenShift newOpenShift) throws ClientException {
        return (OpenShift)this.send(HttpMethod.POST, newOpenShift);
    }

    @Override
    public void put(OpenShift newOpenShift, ICallback<OpenShift> callback) {
        this.send(HttpMethod.PUT, callback, newOpenShift);
    }

    @Override
    public OpenShift put(OpenShift newOpenShift) throws ClientException {
        return (OpenShift)this.send(HttpMethod.PUT, newOpenShift);
    }

    @Override
    public IOpenShiftRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOpenShiftRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

