/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOAuth2PermissionGrantCollectionPage;
import com.microsoft.graph.requests.extensions.IOAuth2PermissionGrantCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IOAuth2PermissionGrantCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.OAuth2PermissionGrantCollectionResponse;
import com.microsoft.graph.requests.extensions.OAuth2PermissionGrantCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.OAuth2PermissionGrantCollectionWithReferencesRequestBuilder;
import java.util.List;

public class OAuth2PermissionGrantCollectionWithReferencesRequest
extends BaseCollectionRequest<OAuth2PermissionGrantCollectionResponse, IOAuth2PermissionGrantCollectionPage>
implements IOAuth2PermissionGrantCollectionWithReferencesRequest {
    public OAuth2PermissionGrantCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OAuth2PermissionGrantCollectionResponse.class, IOAuth2PermissionGrantCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IOAuth2PermissionGrantCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(OAuth2PermissionGrantCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOAuth2PermissionGrantCollectionWithReferencesPage get() throws ClientException {
        OAuth2PermissionGrantCollectionResponse response = (OAuth2PermissionGrantCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IOAuth2PermissionGrantCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IOAuth2PermissionGrantCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOAuth2PermissionGrantCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IOAuth2PermissionGrantCollectionWithReferencesPage buildFromResponse(OAuth2PermissionGrantCollectionResponse response) {
        OAuth2PermissionGrantCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new OAuth2PermissionGrantCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OAuth2PermissionGrantCollectionWithReferencesPage page = new OAuth2PermissionGrantCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

