/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Event;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IEventRequest;
import java.util.List;

public class EventRequest
extends BaseRequest
implements IEventRequest {
    public EventRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Event.class);
    }

    @Override
    public void get(ICallback<Event> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Event get() throws ClientException {
        return (Event)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<Event> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Event sourceEvent, ICallback<Event> callback) {
        this.send(HttpMethod.PATCH, callback, sourceEvent);
    }

    @Override
    public Event patch(Event sourceEvent) throws ClientException {
        return (Event)this.send(HttpMethod.PATCH, sourceEvent);
    }

    @Override
    public void post(Event newEvent, ICallback<Event> callback) {
        this.send(HttpMethod.POST, callback, newEvent);
    }

    @Override
    public Event post(Event newEvent) throws ClientException {
        return (Event)this.send(HttpMethod.POST, newEvent);
    }

    @Override
    public void put(Event newEvent, ICallback<Event> callback) {
        this.send(HttpMethod.PUT, callback, newEvent);
    }

    @Override
    public Event put(Event newEvent) throws ClientException {
        return (Event)this.send(HttpMethod.PUT, newEvent);
    }

    @Override
    public IEventRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IEventRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

