// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.WorkbookRangeSort;
import com.microsoft.graph.models.extensions.WorkbookSortField;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Range Sort Request.
 */
public class WorkbookRangeSortRequest extends BaseRequest implements IWorkbookRangeSortRequest {
	
    /**
     * The request for the WorkbookRangeSort
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookRangeSortRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookRangeSort.class);
    }

    /**
     * Gets the WorkbookRangeSort from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<WorkbookRangeSort> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookRangeSort from the service
     *
     * @return the WorkbookRangeSort from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WorkbookRangeSort get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<WorkbookRangeSort> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WorkbookRangeSort with a source
     *
     * @param sourceWorkbookRangeSort the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final WorkbookRangeSort sourceWorkbookRangeSort, final ICallback<WorkbookRangeSort> callback) {
        send(HttpMethod.PATCH, callback, sourceWorkbookRangeSort);
    }

    /**
     * Patches this WorkbookRangeSort with a source
     *
     * @param sourceWorkbookRangeSort the source object with updates
     * @return the updated WorkbookRangeSort
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WorkbookRangeSort patch(final WorkbookRangeSort sourceWorkbookRangeSort) throws ClientException {
        return send(HttpMethod.PATCH, sourceWorkbookRangeSort);
    }

    /**
     * Creates a WorkbookRangeSort with a new object
     *
     * @param newWorkbookRangeSort the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final WorkbookRangeSort newWorkbookRangeSort, final ICallback<WorkbookRangeSort> callback) {
        send(HttpMethod.POST, callback, newWorkbookRangeSort);
    }

    /**
     * Creates a WorkbookRangeSort with a new object
     *
     * @param newWorkbookRangeSort the new object to create
     * @return the created WorkbookRangeSort
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WorkbookRangeSort post(final WorkbookRangeSort newWorkbookRangeSort) throws ClientException {
        return send(HttpMethod.POST, newWorkbookRangeSort);
    }

    /**
     * Creates a WorkbookRangeSort with a new object
     *
     * @param newWorkbookRangeSort the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final WorkbookRangeSort newWorkbookRangeSort, final ICallback<WorkbookRangeSort> callback) {
        send(HttpMethod.PUT, callback, newWorkbookRangeSort);
    }

    /**
     * Creates a WorkbookRangeSort with a new object
     *
     * @param newWorkbookRangeSort the object to create/update
     * @return the created WorkbookRangeSort
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WorkbookRangeSort put(final WorkbookRangeSort newWorkbookRangeSort) throws ClientException {
        return send(HttpMethod.PUT, newWorkbookRangeSort);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IWorkbookRangeSortRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (WorkbookRangeSortRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IWorkbookRangeSortRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (WorkbookRangeSortRequest)this;
     }

}

