// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.SignIn;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Sign In Request.
 */
public class SignInRequest extends BaseRequest implements ISignInRequest {
	
    /**
     * The request for the SignIn
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public SignInRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            final Class<? extends SignIn> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the SignIn
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SignInRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SignIn.class);
    }

    /**
     * Gets the SignIn from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<SignIn> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the SignIn from the service
     *
     * @return the SignIn from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SignIn get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<SignIn> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SignIn with a source
     *
     * @param sourceSignIn the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final SignIn sourceSignIn, final ICallback<SignIn> callback) {
        send(HttpMethod.PATCH, callback, sourceSignIn);
    }

    /**
     * Patches this SignIn with a source
     *
     * @param sourceSignIn the source object with updates
     * @return the updated SignIn
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SignIn patch(final SignIn sourceSignIn) throws ClientException {
        return send(HttpMethod.PATCH, sourceSignIn);
    }

    /**
     * Creates a SignIn with a new object
     *
     * @param newSignIn the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final SignIn newSignIn, final ICallback<SignIn> callback) {
        send(HttpMethod.POST, callback, newSignIn);
    }

    /**
     * Creates a SignIn with a new object
     *
     * @param newSignIn the new object to create
     * @return the created SignIn
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SignIn post(final SignIn newSignIn) throws ClientException {
        return send(HttpMethod.POST, newSignIn);
    }

    /**
     * Creates a SignIn with a new object
     *
     * @param newSignIn the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final SignIn newSignIn, final ICallback<SignIn> callback) {
        send(HttpMethod.PUT, callback, newSignIn);
    }

    /**
     * Creates a SignIn with a new object
     *
     * @param newSignIn the object to create/update
     * @return the created SignIn
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public SignIn put(final SignIn newSignIn) throws ClientException {
        return send(HttpMethod.PUT, newSignIn);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public ISignInRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (SignInRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public ISignInRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (SignInRequest)this;
     }

}

