// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Windows10GeneralConfiguration;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Windows10General Configuration Request.
 */
public interface IWindows10GeneralConfigurationRequest extends IHttpRequest {

    /**
     * Gets the Windows10GeneralConfiguration from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<Windows10GeneralConfiguration> callback);

    /**
     * Gets the Windows10GeneralConfiguration from the service
     *
     * @return the Windows10GeneralConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Windows10GeneralConfiguration get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<Windows10GeneralConfiguration> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Windows10GeneralConfiguration with a source
     *
     * @param sourceWindows10GeneralConfiguration the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Windows10GeneralConfiguration sourceWindows10GeneralConfiguration, final ICallback<Windows10GeneralConfiguration> callback);

    /**
     * Patches this Windows10GeneralConfiguration with a source
     *
     * @param sourceWindows10GeneralConfiguration the source object with updates
     * @return the updated Windows10GeneralConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Windows10GeneralConfiguration patch(final Windows10GeneralConfiguration sourceWindows10GeneralConfiguration) throws ClientException;

    /**
     * Posts a Windows10GeneralConfiguration with a new object
     *
     * @param newWindows10GeneralConfiguration the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Windows10GeneralConfiguration newWindows10GeneralConfiguration, final ICallback<Windows10GeneralConfiguration> callback);

    /**
     * Posts a Windows10GeneralConfiguration with a new object
     *
     * @param newWindows10GeneralConfiguration the new object to create
     * @return the created Windows10GeneralConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Windows10GeneralConfiguration post(final Windows10GeneralConfiguration newWindows10GeneralConfiguration) throws ClientException;

    /**
     * Posts a Windows10GeneralConfiguration with a new object
     *
     * @param newWindows10GeneralConfiguration the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final Windows10GeneralConfiguration newWindows10GeneralConfiguration, final ICallback<Windows10GeneralConfiguration> callback);

    /**
     * Posts a Windows10GeneralConfiguration with a new object
     *
     * @param newWindows10GeneralConfiguration the object to create/update
     * @return the created Windows10GeneralConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Windows10GeneralConfiguration put(final Windows10GeneralConfiguration newWindows10GeneralConfiguration) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWindows10GeneralConfigurationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWindows10GeneralConfigurationRequest expand(final String value);

}

