// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.UserSettings;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the User Settings Request.
 */
public interface IUserSettingsRequest extends IHttpRequest {

    /**
     * Gets the UserSettings from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<UserSettings> callback);

    /**
     * Gets the UserSettings from the service
     *
     * @return the UserSettings from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    UserSettings get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<UserSettings> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this UserSettings with a source
     *
     * @param sourceUserSettings the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final UserSettings sourceUserSettings, final ICallback<UserSettings> callback);

    /**
     * Patches this UserSettings with a source
     *
     * @param sourceUserSettings the source object with updates
     * @return the updated UserSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    UserSettings patch(final UserSettings sourceUserSettings) throws ClientException;

    /**
     * Posts a UserSettings with a new object
     *
     * @param newUserSettings the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final UserSettings newUserSettings, final ICallback<UserSettings> callback);

    /**
     * Posts a UserSettings with a new object
     *
     * @param newUserSettings the new object to create
     * @return the created UserSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    UserSettings post(final UserSettings newUserSettings) throws ClientException;

    /**
     * Posts a UserSettings with a new object
     *
     * @param newUserSettings the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final UserSettings newUserSettings, final ICallback<UserSettings> callback);

    /**
     * Posts a UserSettings with a new object
     *
     * @param newUserSettings the object to create/update
     * @return the created UserSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    UserSettings put(final UserSettings newUserSettings) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IUserSettingsRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IUserSettingsRequest expand(final String value);

}

