// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Security;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Security Request.
 */
public interface ISecurityRequest extends IHttpRequest {

    /**
     * Gets the Security from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<Security> callback);

    /**
     * Gets the Security from the service
     *
     * @return the Security from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Security get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<Security> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Security with a source
     *
     * @param sourceSecurity the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Security sourceSecurity, final ICallback<Security> callback);

    /**
     * Patches this Security with a source
     *
     * @param sourceSecurity the source object with updates
     * @return the updated Security
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Security patch(final Security sourceSecurity) throws ClientException;

    /**
     * Posts a Security with a new object
     *
     * @param newSecurity the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Security newSecurity, final ICallback<Security> callback);

    /**
     * Posts a Security with a new object
     *
     * @param newSecurity the new object to create
     * @return the created Security
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Security post(final Security newSecurity) throws ClientException;

    /**
     * Posts a Security with a new object
     *
     * @param newSecurity the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final Security newSecurity, final ICallback<Security> callback);

    /**
     * Posts a Security with a new object
     *
     * @param newSecurity the object to create/update
     * @return the created Security
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Security put(final Security newSecurity) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ISecurityRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ISecurityRequest expand(final String value);

}

