// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.DeviceConfigurationUserOverview;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Device Configuration User Overview Request.
 */
public interface IDeviceConfigurationUserOverviewRequest extends IHttpRequest {

    /**
     * Gets the DeviceConfigurationUserOverview from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<DeviceConfigurationUserOverview> callback);

    /**
     * Gets the DeviceConfigurationUserOverview from the service
     *
     * @return the DeviceConfigurationUserOverview from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfigurationUserOverview get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<DeviceConfigurationUserOverview> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DeviceConfigurationUserOverview with a source
     *
     * @param sourceDeviceConfigurationUserOverview the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final DeviceConfigurationUserOverview sourceDeviceConfigurationUserOverview, final ICallback<DeviceConfigurationUserOverview> callback);

    /**
     * Patches this DeviceConfigurationUserOverview with a source
     *
     * @param sourceDeviceConfigurationUserOverview the source object with updates
     * @return the updated DeviceConfigurationUserOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfigurationUserOverview patch(final DeviceConfigurationUserOverview sourceDeviceConfigurationUserOverview) throws ClientException;

    /**
     * Posts a DeviceConfigurationUserOverview with a new object
     *
     * @param newDeviceConfigurationUserOverview the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final DeviceConfigurationUserOverview newDeviceConfigurationUserOverview, final ICallback<DeviceConfigurationUserOverview> callback);

    /**
     * Posts a DeviceConfigurationUserOverview with a new object
     *
     * @param newDeviceConfigurationUserOverview the new object to create
     * @return the created DeviceConfigurationUserOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfigurationUserOverview post(final DeviceConfigurationUserOverview newDeviceConfigurationUserOverview) throws ClientException;

    /**
     * Posts a DeviceConfigurationUserOverview with a new object
     *
     * @param newDeviceConfigurationUserOverview the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final DeviceConfigurationUserOverview newDeviceConfigurationUserOverview, final ICallback<DeviceConfigurationUserOverview> callback);

    /**
     * Posts a DeviceConfigurationUserOverview with a new object
     *
     * @param newDeviceConfigurationUserOverview the object to create/update
     * @return the created DeviceConfigurationUserOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceConfigurationUserOverview put(final DeviceConfigurationUserOverview newDeviceConfigurationUserOverview) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDeviceConfigurationUserOverviewRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDeviceConfigurationUserOverviewRequest expand(final String value);

}

