// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.FileAttachment;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the File Attachment Request.
 */
public class FileAttachmentRequest extends BaseRequest implements IFileAttachmentRequest {
	
    /**
     * The request for the FileAttachment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public FileAttachmentRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, FileAttachment.class);
    }

    /**
     * Gets the FileAttachment from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<FileAttachment> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the FileAttachment from the service
     *
     * @return the FileAttachment from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public FileAttachment get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<FileAttachment> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this FileAttachment with a source
     *
     * @param sourceFileAttachment the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final FileAttachment sourceFileAttachment, final ICallback<FileAttachment> callback) {
        send(HttpMethod.PATCH, callback, sourceFileAttachment);
    }

    /**
     * Patches this FileAttachment with a source
     *
     * @param sourceFileAttachment the source object with updates
     * @return the updated FileAttachment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public FileAttachment patch(final FileAttachment sourceFileAttachment) throws ClientException {
        return send(HttpMethod.PATCH, sourceFileAttachment);
    }

    /**
     * Creates a FileAttachment with a new object
     *
     * @param newFileAttachment the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final FileAttachment newFileAttachment, final ICallback<FileAttachment> callback) {
        send(HttpMethod.POST, callback, newFileAttachment);
    }

    /**
     * Creates a FileAttachment with a new object
     *
     * @param newFileAttachment the new object to create
     * @return the created FileAttachment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public FileAttachment post(final FileAttachment newFileAttachment) throws ClientException {
        return send(HttpMethod.POST, newFileAttachment);
    }

    /**
     * Creates a FileAttachment with a new object
     *
     * @param newFileAttachment the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final FileAttachment newFileAttachment, final ICallback<FileAttachment> callback) {
        send(HttpMethod.PUT, callback, newFileAttachment);
    }

    /**
     * Creates a FileAttachment with a new object
     *
     * @param newFileAttachment the object to create/update
     * @return the created FileAttachment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public FileAttachment put(final FileAttachment newFileAttachment) throws ClientException {
        return send(HttpMethod.PUT, newFileAttachment);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IFileAttachmentRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (FileAttachmentRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IFileAttachmentRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (FileAttachmentRequest)this;
     }

}

