// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IAttachmentCreateUploadSessionRequest;
import com.microsoft.graph.requests.extensions.AttachmentCreateUploadSessionRequest;
import com.microsoft.graph.models.extensions.AttachmentItem;
import com.microsoft.graph.models.extensions.UploadSession;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Attachment Create Upload Session Request Builder.
 */
public class AttachmentCreateUploadSessionRequestBuilder extends BaseActionRequestBuilder implements IAttachmentCreateUploadSessionRequestBuilder {

    /**
     * The request builder for this AttachmentCreateUploadSession
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param attachmentItem the attachmentItem
     */
    public AttachmentCreateUploadSessionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final AttachmentItem attachmentItem) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("attachmentItem", attachmentItem);
    }

    /**
     * Creates the IAttachmentCreateUploadSessionRequest
     *
     * @return the IAttachmentCreateUploadSessionRequest instance
     */
    public IAttachmentCreateUploadSessionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IAttachmentCreateUploadSessionRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IAttachmentCreateUploadSessionRequest instance
     */
    public IAttachmentCreateUploadSessionRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        AttachmentCreateUploadSessionRequest request = new AttachmentCreateUploadSessionRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("attachmentItem")) {
            request.body.attachmentItem = getParameter("attachmentItem");
        }

        return request;
    }
}
