/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceConfigurationAssignment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceConfigurationAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceConfigurationAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceConfigurationAssignmentCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceConfigurationAssignmentRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceConfigurationAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceConfigurationAssignmentCollectionRequest;
import java.util.List;

public class DeviceConfigurationAssignmentCollectionRequest
extends BaseCollectionRequest<DeviceConfigurationAssignmentCollectionResponse, IDeviceConfigurationAssignmentCollectionPage>
implements IDeviceConfigurationAssignmentCollectionRequest {
    public DeviceConfigurationAssignmentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceConfigurationAssignmentCollectionResponse.class, IDeviceConfigurationAssignmentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceConfigurationAssignmentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DeviceConfigurationAssignmentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceConfigurationAssignmentCollectionPage get() throws ClientException {
        DeviceConfigurationAssignmentCollectionResponse response = (DeviceConfigurationAssignmentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceConfigurationAssignment newDeviceConfigurationAssignment, ICallback<DeviceConfigurationAssignment> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceConfigurationAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceConfigurationAssignment, callback);
    }

    @Override
    public DeviceConfigurationAssignment post(DeviceConfigurationAssignment newDeviceConfigurationAssignment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceConfigurationAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getOptions()).post(newDeviceConfigurationAssignment);
    }

    @Override
    public IDeviceConfigurationAssignmentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDeviceConfigurationAssignmentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceConfigurationAssignmentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IDeviceConfigurationAssignmentCollectionPage buildFromResponse(DeviceConfigurationAssignmentCollectionResponse response) {
        DeviceConfigurationAssignmentCollectionRequestBuilder builder = response.nextLink != null ? new DeviceConfigurationAssignmentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceConfigurationAssignmentCollectionPage page = new DeviceConfigurationAssignmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

