/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.extensions;

import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.models.extensions.Place;
import com.microsoft.graph.models.extensions.Room;
import com.microsoft.graph.requests.extensions.RoomCollectionPage;
import com.microsoft.graph.requests.extensions.RoomCollectionResponse;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import java.util.Arrays;

public class RoomList
extends Place
implements IJsonBackedObject {
    @SerializedName(value="emailAddress")
    @Expose
    public String emailAddress;
    public RoomCollectionPage rooms;
    private JsonObject rawObject;
    private ISerializer serializer;

    @Override
    public JsonObject getRawObject() {
        return this.rawObject;
    }

    @Override
    protected ISerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public void setRawObject(ISerializer serializer, JsonObject json) {
        this.serializer = serializer;
        this.rawObject = json;
        if (json.has("rooms")) {
            RoomCollectionResponse response = new RoomCollectionResponse();
            if (json.has("rooms@odata.nextLink")) {
                response.nextLink = json.get("rooms@odata.nextLink").getAsString();
            }
            JsonObject[] sourceArray = serializer.deserializeObject(json.get("rooms").toString(), JsonObject[].class);
            Room[] array = new Room[sourceArray.length];
            for (int i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), Room.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            this.rooms = new RoomCollectionPage(response, null);
        }
    }
}

