// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.WindowsMobileMSI;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Mobile MSIRequest.
 */
public class WindowsMobileMSIRequest extends BaseRequest implements IWindowsMobileMSIRequest {
	
    /**
     * The request for the WindowsMobileMSI
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WindowsMobileMSIRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsMobileMSI.class);
    }

    /**
     * Gets the WindowsMobileMSI from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<WindowsMobileMSI> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WindowsMobileMSI from the service
     *
     * @return the WindowsMobileMSI from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WindowsMobileMSI get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<WindowsMobileMSI> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WindowsMobileMSI with a source
     *
     * @param sourceWindowsMobileMSI the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final WindowsMobileMSI sourceWindowsMobileMSI, final ICallback<WindowsMobileMSI> callback) {
        send(HttpMethod.PATCH, callback, sourceWindowsMobileMSI);
    }

    /**
     * Patches this WindowsMobileMSI with a source
     *
     * @param sourceWindowsMobileMSI the source object with updates
     * @return the updated WindowsMobileMSI
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WindowsMobileMSI patch(final WindowsMobileMSI sourceWindowsMobileMSI) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindowsMobileMSI);
    }

    /**
     * Creates a WindowsMobileMSI with a new object
     *
     * @param newWindowsMobileMSI the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final WindowsMobileMSI newWindowsMobileMSI, final ICallback<WindowsMobileMSI> callback) {
        send(HttpMethod.POST, callback, newWindowsMobileMSI);
    }

    /**
     * Creates a WindowsMobileMSI with a new object
     *
     * @param newWindowsMobileMSI the new object to create
     * @return the created WindowsMobileMSI
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WindowsMobileMSI post(final WindowsMobileMSI newWindowsMobileMSI) throws ClientException {
        return send(HttpMethod.POST, newWindowsMobileMSI);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IWindowsMobileMSIRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (WindowsMobileMSIRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IWindowsMobileMSIRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (WindowsMobileMSIRequest)this;
     }

}

