// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.TeamsTemplate;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.core.IBaseClient;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teams Template Reference Request.
 */
public class TeamsTemplateReferenceRequest extends BaseRequest implements ITeamsTemplateReferenceRequest {

    /**
     * The request for the TeamsTemplate
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TeamsTemplateReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamsTemplate.class);
    }

    public void delete(final ICallback<TeamsTemplate> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public TeamsTemplate delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ITeamsTemplateReferenceRequest select(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
        return (TeamsTemplateReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ITeamsTemplateReferenceRequest expand(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (TeamsTemplateReferenceRequest)this;
    }
    /**
     * Puts the TeamsTemplate
     *
     * @param srcTeamsTemplate the TeamsTemplate reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(TeamsTemplate srcTeamsTemplate, final ICallback<TeamsTemplate> callback) {
        send(HttpMethod.PUT, callback, srcTeamsTemplate);
    }

    /**
     * Puts the TeamsTemplate
     *
     * @param srcTeamsTemplate the TeamsTemplate reference to PUT
     * @return the TeamsTemplate
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public TeamsTemplate put(TeamsTemplate srcTeamsTemplate) throws ClientException {
        return send(HttpMethod.PUT, srcTeamsTemplate);
    }
}
