// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IReportRootManagedDeviceEnrollmentFailureDetailsRequest;
import com.microsoft.graph.requests.extensions.ReportRootManagedDeviceEnrollmentFailureDetailsRequest;
import com.microsoft.graph.models.extensions.Report;
import com.microsoft.graph.models.extensions.Report;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Report Root Managed Device Enrollment Failure Details Request Builder.
 */
public class ReportRootManagedDeviceEnrollmentFailureDetailsRequestBuilder extends BaseFunctionRequestBuilder implements IReportRootManagedDeviceEnrollmentFailureDetailsRequestBuilder {

    /**
     * The request builder for this ReportRootManagedDeviceEnrollmentFailureDetails
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ReportRootManagedDeviceEnrollmentFailureDetailsRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    /**
     * The request builder for this ReportRootManagedDeviceEnrollmentFailureDetails
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param skip the skip
     * @param top the top
     * @param filter the filter
     * @param skipToken the skipToken
     */
    public ReportRootManagedDeviceEnrollmentFailureDetailsRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final Integer skip, final Integer top, final String filter, final String skipToken) {
        super(requestUrl, client, requestOptions);
        functionOptions.add(new com.microsoft.graph.options.FunctionOption("skip", skip));
        functionOptions.add(new com.microsoft.graph.options.FunctionOption("top", top));
        functionOptions.add(new com.microsoft.graph.options.FunctionOption("filter", filter));
        functionOptions.add(new com.microsoft.graph.options.FunctionOption("skipToken", skipToken));
    }

    /**
     * Creates the IReportRootManagedDeviceEnrollmentFailureDetailsRequest
     *
     * @return the IReportRootManagedDeviceEnrollmentFailureDetailsRequest instance
     */
    public IReportRootManagedDeviceEnrollmentFailureDetailsRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IReportRootManagedDeviceEnrollmentFailureDetailsRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IReportRootManagedDeviceEnrollmentFailureDetailsRequest instance
     */
    public IReportRootManagedDeviceEnrollmentFailureDetailsRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        ReportRootManagedDeviceEnrollmentFailureDetailsRequest request = new ReportRootManagedDeviceEnrollmentFailureDetailsRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

      for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
            request.addFunctionOption(option);
      }

        return request;
    }
}
