// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IRemoteAssistancePartnerDisconnectRequest;
import com.microsoft.graph.requests.extensions.RemoteAssistancePartnerDisconnectRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Remote Assistance Partner Disconnect Request Builder.
 */
public class RemoteAssistancePartnerDisconnectRequestBuilder extends BaseActionRequestBuilder implements IRemoteAssistancePartnerDisconnectRequestBuilder {

    /**
     * The request builder for this RemoteAssistancePartnerDisconnect
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RemoteAssistancePartnerDisconnectRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IRemoteAssistancePartnerDisconnectRequest
     *
     * @return the IRemoteAssistancePartnerDisconnectRequest instance
     */
    public IRemoteAssistancePartnerDisconnectRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IRemoteAssistancePartnerDisconnectRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IRemoteAssistancePartnerDisconnectRequest instance
     */
    public IRemoteAssistancePartnerDisconnectRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        RemoteAssistancePartnerDisconnectRequest request = new RemoteAssistancePartnerDisconnectRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
