// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Permission;
import com.microsoft.graph.models.extensions.DriveRecipient;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Permission Request.
 */
public class PermissionRequest extends BaseRequest implements IPermissionRequest {
	
    /**
     * The request for the Permission
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PermissionRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Permission.class);
    }

    /**
     * Gets the Permission from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<Permission> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the Permission from the service
     *
     * @return the Permission from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Permission get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<Permission> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Permission with a source
     *
     * @param sourcePermission the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final Permission sourcePermission, final ICallback<Permission> callback) {
        send(HttpMethod.PATCH, callback, sourcePermission);
    }

    /**
     * Patches this Permission with a source
     *
     * @param sourcePermission the source object with updates
     * @return the updated Permission
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Permission patch(final Permission sourcePermission) throws ClientException {
        return send(HttpMethod.PATCH, sourcePermission);
    }

    /**
     * Creates a Permission with a new object
     *
     * @param newPermission the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final Permission newPermission, final ICallback<Permission> callback) {
        send(HttpMethod.POST, callback, newPermission);
    }

    /**
     * Creates a Permission with a new object
     *
     * @param newPermission the new object to create
     * @return the created Permission
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Permission post(final Permission newPermission) throws ClientException {
        return send(HttpMethod.POST, newPermission);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IPermissionRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (PermissionRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IPermissionRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (PermissionRequest)this;
     }

}

