// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.LocaleInfo;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.IOutlookUserSupportedLanguagesCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OutlookUserSupportedLanguagesCollectionPage;
import com.microsoft.graph.requests.extensions.OutlookUserSupportedLanguagesCollectionResponse;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.IBaseCollectionPage;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Outlook User Supported Languages Collection Page.
 */
public class OutlookUserSupportedLanguagesCollectionPage extends BaseCollectionPage<LocaleInfo, IOutlookUserSupportedLanguagesCollectionRequestBuilder> implements IOutlookUserSupportedLanguagesCollectionPage {

    /**
     * A collection page for LocaleInfo.
     *
     * @param response The serialized OutlookUserSupportedLanguagesCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public OutlookUserSupportedLanguagesCollectionPage(final OutlookUserSupportedLanguagesCollectionResponse response, final IOutlookUserSupportedLanguagesCollectionRequestBuilder builder) {
       super(response.value, builder);
    }
}
