// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.OnenoteSection;
import com.microsoft.graph.models.extensions.OnenoteOperation;
import com.microsoft.graph.requests.extensions.IOnenotePageCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IOnenotePageRequestBuilder;
import com.microsoft.graph.requests.extensions.OnenotePageCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OnenotePageRequestBuilder;
import com.microsoft.graph.requests.extensions.INotebookRequestBuilder;
import com.microsoft.graph.requests.extensions.NotebookRequestBuilder;
import com.microsoft.graph.requests.extensions.ISectionGroupRequestBuilder;
import com.microsoft.graph.requests.extensions.SectionGroupRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Onenote Section Request.
 */
public class OnenoteSectionRequest extends BaseRequest implements IOnenoteSectionRequest {
	
    /**
     * The request for the OnenoteSection
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OnenoteSectionRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, OnenoteSection.class);
    }

    /**
     * Gets the OnenoteSection from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<OnenoteSection> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the OnenoteSection from the service
     *
     * @return the OnenoteSection from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OnenoteSection get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<OnenoteSection> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this OnenoteSection with a source
     *
     * @param sourceOnenoteSection the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final OnenoteSection sourceOnenoteSection, final ICallback<OnenoteSection> callback) {
        send(HttpMethod.PATCH, callback, sourceOnenoteSection);
    }

    /**
     * Patches this OnenoteSection with a source
     *
     * @param sourceOnenoteSection the source object with updates
     * @return the updated OnenoteSection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OnenoteSection patch(final OnenoteSection sourceOnenoteSection) throws ClientException {
        return send(HttpMethod.PATCH, sourceOnenoteSection);
    }

    /**
     * Creates a OnenoteSection with a new object
     *
     * @param newOnenoteSection the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final OnenoteSection newOnenoteSection, final ICallback<OnenoteSection> callback) {
        send(HttpMethod.POST, callback, newOnenoteSection);
    }

    /**
     * Creates a OnenoteSection with a new object
     *
     * @param newOnenoteSection the new object to create
     * @return the created OnenoteSection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OnenoteSection post(final OnenoteSection newOnenoteSection) throws ClientException {
        return send(HttpMethod.POST, newOnenoteSection);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IOnenoteSectionRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (OnenoteSectionRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IOnenoteSectionRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (OnenoteSectionRequest)this;
     }

}

