// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.OnenoteResource;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Onenote Resource Request.
 */
public class OnenoteResourceRequest extends BaseRequest implements IOnenoteResourceRequest {
	
    /**
     * The request for the OnenoteResource
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OnenoteResourceRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, OnenoteResource.class);
    }

    /**
     * Gets the OnenoteResource from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<OnenoteResource> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the OnenoteResource from the service
     *
     * @return the OnenoteResource from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OnenoteResource get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<OnenoteResource> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this OnenoteResource with a source
     *
     * @param sourceOnenoteResource the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final OnenoteResource sourceOnenoteResource, final ICallback<OnenoteResource> callback) {
        send(HttpMethod.PATCH, callback, sourceOnenoteResource);
    }

    /**
     * Patches this OnenoteResource with a source
     *
     * @param sourceOnenoteResource the source object with updates
     * @return the updated OnenoteResource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OnenoteResource patch(final OnenoteResource sourceOnenoteResource) throws ClientException {
        return send(HttpMethod.PATCH, sourceOnenoteResource);
    }

    /**
     * Creates a OnenoteResource with a new object
     *
     * @param newOnenoteResource the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final OnenoteResource newOnenoteResource, final ICallback<OnenoteResource> callback) {
        send(HttpMethod.POST, callback, newOnenoteResource);
    }

    /**
     * Creates a OnenoteResource with a new object
     *
     * @param newOnenoteResource the new object to create
     * @return the created OnenoteResource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public OnenoteResource post(final OnenoteResource newOnenoteResource) throws ClientException {
        return send(HttpMethod.POST, newOnenoteResource);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IOnenoteResourceRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (OnenoteResourceRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IOnenoteResourceRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (OnenoteResourceRequest)this;
     }

}

