// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Schedule;
import com.microsoft.graph.models.extensions.OfferShiftRequest;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.requests.extensions.IOfferShiftRequestCollectionPage;
import com.microsoft.graph.requests.extensions.OfferShiftRequestCollectionResponse;
import com.microsoft.graph.requests.extensions.IOfferShiftRequestCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IOfferShiftRequestCollectionRequest;
import com.microsoft.graph.requests.extensions.OfferShiftRequestCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Offer Shift Request Collection Request.
 */
public class OfferShiftRequestCollectionRequest extends BaseCollectionRequest<OfferShiftRequestCollectionResponse, IOfferShiftRequestCollectionPage> implements IOfferShiftRequestCollectionRequest {

    /**
     * The request builder for this collection of OfferShiftRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OfferShiftRequestCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, OfferShiftRequestCollectionResponse.class, IOfferShiftRequestCollectionPage.class);
    }

    public void get(final ICallback<IOfferShiftRequestCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IOfferShiftRequestCollectionPage get() throws ClientException {
        final OfferShiftRequestCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final OfferShiftRequest newOfferShiftRequest, final ICallback<OfferShiftRequest> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new OfferShiftRequestRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newOfferShiftRequest, callback);
    }

    public OfferShiftRequest post(final OfferShiftRequest newOfferShiftRequest) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new OfferShiftRequestRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newOfferShiftRequest);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IOfferShiftRequestCollectionRequest expand(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (OfferShiftRequestCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IOfferShiftRequestCollectionRequest select(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$select", value));
        return (OfferShiftRequestCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IOfferShiftRequestCollectionRequest top(final int value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$top", value + ""));
        return (OfferShiftRequestCollectionRequest)this;
    }

    public IOfferShiftRequestCollectionPage buildFromResponse(final OfferShiftRequestCollectionResponse response) {
        final IOfferShiftRequestCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new OfferShiftRequestCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final OfferShiftRequestCollectionPage page = new OfferShiftRequestCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
