// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.MessageRule;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Message Rule Request.
 */
public class MessageRuleRequest extends BaseRequest implements IMessageRuleRequest {
	
    /**
     * The request for the MessageRule
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MessageRuleRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MessageRule.class);
    }

    /**
     * Gets the MessageRule from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<MessageRule> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the MessageRule from the service
     *
     * @return the MessageRule from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public MessageRule get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<MessageRule> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MessageRule with a source
     *
     * @param sourceMessageRule the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final MessageRule sourceMessageRule, final ICallback<MessageRule> callback) {
        send(HttpMethod.PATCH, callback, sourceMessageRule);
    }

    /**
     * Patches this MessageRule with a source
     *
     * @param sourceMessageRule the source object with updates
     * @return the updated MessageRule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public MessageRule patch(final MessageRule sourceMessageRule) throws ClientException {
        return send(HttpMethod.PATCH, sourceMessageRule);
    }

    /**
     * Creates a MessageRule with a new object
     *
     * @param newMessageRule the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final MessageRule newMessageRule, final ICallback<MessageRule> callback) {
        send(HttpMethod.POST, callback, newMessageRule);
    }

    /**
     * Creates a MessageRule with a new object
     *
     * @param newMessageRule the new object to create
     * @return the created MessageRule
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public MessageRule post(final MessageRule newMessageRule) throws ClientException {
        return send(HttpMethod.POST, newMessageRule);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IMessageRuleRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (MessageRuleRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IMessageRuleRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (MessageRuleRequest)this;
     }

}

