// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.ItemAttachment;
import com.microsoft.graph.requests.extensions.IOutlookItemRequestBuilder;
import com.microsoft.graph.requests.extensions.OutlookItemRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Item Attachment Request Builder.
 */
public class ItemAttachmentRequestBuilder extends BaseRequestBuilder implements IItemAttachmentRequestBuilder {

    /**
     * The request builder for the ItemAttachment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ItemAttachmentRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IItemAttachmentRequest instance
     */
    public IItemAttachmentRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IItemAttachmentRequest instance
     */
    public IItemAttachmentRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.extensions.ItemAttachmentRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for OutlookItem
     *
     * @return the IOutlookItemRequestBuilder instance
     */
    public IOutlookItemRequestBuilder item() {
        return new OutlookItemRequestBuilder(getRequestUrlWithAdditionalSegment("item"), getClient(), null);
    }
}
