// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.IosVppEBook;
import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Ios Vpp EBook Request Builder.
 */
public interface IIosVppEBookRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IIosVppEBookRequest instance
     */
    IIosVppEBookRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IIosVppEBookRequest instance
     */
    IIosVppEBookRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions);


    IManagedEBookAssignmentCollectionRequestBuilder assignments();

    IManagedEBookAssignmentRequestBuilder assignments(final String id);

    /**
     * Gets the request builder for EBookInstallSummary
     *
     * @return the IEBookInstallSummaryRequestBuilder instance
     */
    IEBookInstallSummaryRequestBuilder installSummary();

    IDeviceInstallStateCollectionRequestBuilder deviceStates();

    IDeviceInstallStateRequestBuilder deviceStates(final String id);

    IUserInstallStateSummaryCollectionRequestBuilder userStateSummary();

    IUserInstallStateSummaryRequestBuilder userStateSummary(final String id);

}